/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyAttributes;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.misc.DogArrow;
import doggytalents.common.entity.misc.DogFoodProjectile;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import doggytalents.common.entity.misc.DogPlushie;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.entity.misc.DoggyBeamEntity;
import doggytalents.common.entity.misc.Piano;
import doggytalents.common.util.Util;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DoggyEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (String)"doggytalents");
    public static final RegistryObject<EntityType<Dog>> DOG = DoggyEntityTypes.register("dog", Dog::new, MobCategory.CREATURE, b -> b.m_20699_(0.6f, 0.85f).setUpdateInterval(3).setTrackingRange(16).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<DoggyBeamEntity>> DOG_BEAM = DoggyEntityTypes.register("dog_beam", DoggyBeamEntity::new, MobCategory.MISC, b -> b.m_20699_(0.25f, 0.25f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(DoggyBeamEntity::new).m_20698_());
    public static final RegistryObject<EntityType<Piano>> GRAND_PIANO_BLACK = DoggyEntityTypes.register("grand_piano_black", Piano::new, MobCategory.MISC, b -> b.m_20699_(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final RegistryObject<EntityType<Piano>> GRAND_PIANO_WHITE = DoggyEntityTypes.register("grand_piano_white", (type, level) -> new Piano((EntityType<Piano>)type, level, Piano.PianoType.GRAND, Piano.PianoColor.WHITE), MobCategory.MISC, b -> b.m_20699_(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final RegistryObject<EntityType<Piano>> UPRIGHT_PIANO_BLACK = DoggyEntityTypes.register("upright_piano_black", (type, level) -> new Piano((EntityType<Piano>)type, level, Piano.PianoType.UPRIGHT, Piano.PianoColor.BLACK), MobCategory.MISC, b -> b.m_20699_(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final RegistryObject<EntityType<Piano>> UPRIGHT_PIANO_BROWN = DoggyEntityTypes.register("upright_piano_brown", (type, level) -> new Piano((EntityType<Piano>)type, level, Piano.PianoType.UPRIGHT, Piano.PianoColor.BROWN), MobCategory.MISC, b -> b.m_20699_(3.0f, 3.0f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(false));
    public static final RegistryObject<EntityType<DogPlushie>> DOG_PLUSHIE_TOY = DoggyEntityTypes.register("dog_plushie_toy", (type, level) -> new DogPlushie(type, level), MobCategory.MISC, b -> b.m_20699_(0.5f, 0.5f).setUpdateInterval(3).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<DogFoodProjectile>> DOG_FOOD_PROJ = DoggyEntityTypes.register("dog_food_projectile", DogFoodProjectile::new, MobCategory.MISC, b -> b.m_20699_(0.25f, 0.25f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(DogFoodProjectile::new).m_20698_());
    public static final RegistryObject<EntityType<DogGunpowderProjectile>> DOG_GUNPOWDER_PROJ = DoggyEntityTypes.register("dog_gunpowder_projectile", DogGunpowderProjectile::new, MobCategory.MISC, b -> b.m_20699_(0.25f, 0.25f).setUpdateInterval(4).setTrackingRange(10).setShouldReceiveVelocityUpdates(true).m_20698_());
    public static final Supplier<EntityType<DogThrownTrident>> DOG_TRIDENT_PROJ = DoggyEntityTypes.register("dog_trident_proj", DogThrownTrident::new, MobCategory.MISC, b -> b.m_20699_(0.5f, 0.5f).setTrackingRange(4).m_20717_(20).setShouldReceiveVelocityUpdates(true).m_20698_());
    public static final Supplier<EntityType<DogArrow>> DOG_ARROW_PROJ = DoggyEntityTypes.register("dog_arrow_proj", DogArrow::new, MobCategory.MISC, b -> b.m_20699_(0.5f, 0.5f).setTrackingRange(4).m_20717_(20).setShouldReceiveVelocityUpdates(true).m_20698_());

    private static <E extends Entity, T extends EntityType<E>> RegistryObject<EntityType<E>> register(String name, EntityType.EntityFactory<E> sup, MobCategory classification, Function<EntityType.Builder<E>, EntityType.Builder<E>> builder) {
        return DoggyEntityTypes.register(name, () -> ((EntityType.Builder)builder.apply(EntityType.Builder.m_20704_((EntityType.EntityFactory)sup, (MobCategory)classification))).m_20712_(Util.getResourcePath(name)));
    }

    private static <E extends Entity, T extends EntityType<E>> RegistryObject<T> register(String name, Supplier<T> sup) {
        return ENTITIES.register(name, sup);
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent e) {
        e.put((EntityType)DOG.get(), Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22281_, 2.0).m_22268_((Attribute)DoggyAttributes.JUMP_POWER.get(), 0.42).m_22268_((Attribute)DoggyAttributes.CRIT_CHANCE.get(), 0.01).m_22268_((Attribute)DoggyAttributes.CRIT_BONUS.get(), 1.0).m_22268_(Attributes.f_22280_, 0.3).m_22265_());
    }
}

